unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, System.ComponentModel, Borland.Vcl.Grids,
  System.Text; //StringBuilder

type
  TForm1 = class(TForm)
    StringGrid1: TStringGrid;
    procedure FormShow(Sender: TObject);
    procedure FormResize(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.nfm}

procedure TForm1.FormResize(Sender: TObject);
var  szerokoscPodstawowa :Integer;
begin
//Ustawienie szerokosci
szerokoscPodstawowa:=(ClientWidth div 10)-StringGrid1.GridLineWidth;
StringGrid1.ColWidths[0]:=3*szerokoscPodstawowa;
StringGrid1.ColWidths[1]:=2*szerokoscPodstawowa;
StringGrid1.ColWidths[2]:=szerokoscPodstawowa;
StringGrid1.ColWidths[3]:=szerokoscPodstawowa;
StringGrid1.ColWidths[4]:=szerokoscPodstawowa;
StringGrid1.ColWidths[5]:=szerokoscPodstawowa;
StringGrid1.ColWidths[6]:=szerokoscPodstawowa;

//Naglowki kolumn
StringGrid1.Cells[0,0]:='Tytu okna';
StringGrid1.Cells[1,0]:='Nazwa klasy okna';
StringGrid1.Cells[2,0]:='ID okna';
StringGrid1.Cells[3,0]:='Uchwyt';
StringGrid1.Cells[4,0]:='Stan okna';
StringGrid1.Cells[5,0]:='Pooenie';
StringGrid1.Cells[6,0]:='Rozmiar';
end;

function DodajWiersz(uchwyt :HWND;lParam :LPARAM) :LongBool;
const MAX_CHAR_SIZE=128;
var
  kolumna :Integer;
  tytul :StringBuilder;
  nazwa_klasy :StringBuilder;
  id_procesu :Cardinal;
  ustawieniaOkna :TWindowPlacement;
  stanOkna :String;
  szerOkna,wysOkna :Integer;
begin
if Form1=nil then
  begin
  ShowMessage('Obiekt formy nie jest zainicjowany');
  Exit;
  end;

tytul:=StringBuilder.Create(MAX_CHAR_SIZE);
nazwa_klasy:=StringBuilder.Create(MAX_CHAR_SIZE);
GetWindowText(uchwyt,tytul,tytul.Capacity);
GetClassName(uchwyt,nazwa_klasy,nazwa_klasy.Capacity);
GetWindowThreadProcessId(uchwyt,id_procesu);
GetWindowPlacement(uchwyt,ustawieniaOkna);
case ustawieniaOkna.showCmd of
  SW_HIDE: stanOkna:='ukryte';
  SW_MAXIMIZE: stanOkna:='zmaksymalizowane';
  SW_MINIMIZE,SW_SHOWMINIMIZED,SW_SHOWMINNOACTIVE: stanOkna:='zminimalizowane';
  SW_SHOWNORMAL,SW_SHOW,SW_SHOWNA,SW_SHOWNOACTIVATE,SW_RESTORE: stanOkna:='normalne';
  end;
szerOkna:=ustawieniaOkna.rcNormalPosition.Right-ustawieniaOkna.rcNormalPosition.Left;
wysOkna:=ustawieniaOkna.rcNormalPosition.Bottom-ustawieniaOkna.rcNormalPosition.Top;

if (IsWindowVisible(uchwyt)) then
  begin
  kolumna:=Form1.StringGrid1.RowCount-1;
  Form1.StringGrid1.Cells[0,kolumna]:=tytul.ToString;
  Form1.StringGrid1.Cells[1,kolumna]:=nazwa_klasy.ToString;
  Form1.StringGrid1.Cells[2,kolumna]:=IntToStr(id_procesu);
  Form1.StringGrid1.Cells[3,kolumna]:=IntToStr(uchwyt);
  Form1.StringGrid1.Cells[4,kolumna]:=stanOkna;
  Form1.StringGrid1.Cells[5,kolumna]:='x='+IntToStr(ustawieniaOkna.rcNormalPosition.left)+', y='+IntToStr(ustawieniaOkna.rcNormalPosition.top);
  if stanOkna='zminimalizowane' then Form1.StringGrid1.Cells[5,kolumna]:='';
  Form1.StringGrid1.Cells[6,kolumna]:=IntToStr(szerOkna)+' x '+IntToStr(wysOkna);
  Form1.StringGrid1.RowCount:=Form1.StringGrid1.RowCount+1;
  end;
Result:=True;
end;

procedure TForm1.FormShow(Sender: TObject);
begin
EnumWindows(@DodajWiersz,0);
StringGrid1.RowCount:=StringGrid1.RowCount-1; //usuwanie ostatniego pustego wiersza
end;

end.
